/*
 * Decompiled with CFR 0.152.
 */
package tech.thatgravyboat.creeperoverhaul.common.entity.base;

import java.util.Collection;
import java.util.List;
import net.minecraft.class_1268;
import net.minecraft.class_1269;
import net.minecraft.class_1293;
import net.minecraft.class_1295;
import net.minecraft.class_1297;
import net.minecraft.class_1299;
import net.minecraft.class_1308;
import net.minecraft.class_1309;
import net.minecraft.class_1314;
import net.minecraft.class_1320;
import net.minecraft.class_1347;
import net.minecraft.class_1352;
import net.minecraft.class_1361;
import net.minecraft.class_1376;
import net.minecraft.class_1394;
import net.minecraft.class_1399;
import net.minecraft.class_1400;
import net.minecraft.class_1538;
import net.minecraft.class_1548;
import net.minecraft.class_1588;
import net.minecraft.class_1657;
import net.minecraft.class_1799;
import net.minecraft.class_1802;
import net.minecraft.class_1927;
import net.minecraft.class_1928;
import net.minecraft.class_1935;
import net.minecraft.class_1937;
import net.minecraft.class_2246;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_243;
import net.minecraft.class_2487;
import net.minecraft.class_2680;
import net.minecraft.class_2940;
import net.minecraft.class_2941;
import net.minecraft.class_2943;
import net.minecraft.class_2945;
import net.minecraft.class_3218;
import net.minecraft.class_3417;
import net.minecraft.class_3532;
import net.minecraft.class_3610;
import net.minecraft.class_3611;
import net.minecraft.class_4582;
import net.minecraft.class_5132;
import net.minecraft.class_5134;
import net.minecraft.class_5712;
import net.minecraft.class_6862;
import org.jetbrains.annotations.NotNull;
import software.bernie.geckolib3.core.AnimationState;
import software.bernie.geckolib3.core.IAnimatable;
import software.bernie.geckolib3.core.PlayState;
import software.bernie.geckolib3.core.builder.Animation;
import software.bernie.geckolib3.core.builder.AnimationBuilder;
import software.bernie.geckolib3.core.controller.AnimationController;
import software.bernie.geckolib3.core.event.predicate.AnimationEvent;
import software.bernie.geckolib3.core.manager.AnimationData;
import software.bernie.geckolib3.core.manager.AnimationFactory;
import tech.thatgravyboat.creeperoverhaul.common.entity.base.CreeperType;
import tech.thatgravyboat.creeperoverhaul.common.entity.goals.CreeperAvoidEntitiesGoal;
import tech.thatgravyboat.creeperoverhaul.common.entity.goals.CreeperMeleeAttackGoal;
import tech.thatgravyboat.creeperoverhaul.common.entity.goals.CreeperSwellGoal;
import tech.thatgravyboat.creeperoverhaul.common.registry.ModAttributes;
import tech.thatgravyboat.creeperoverhaul.common.registry.ModItems;

public class BaseCreeper
extends class_1588
implements class_4582,
IAnimatable {
    private static final class_2940<Integer> DATA_SWELL_DIRECTION = class_2945.method_12791(BaseCreeper.class, (class_2941)class_2943.field_13327);
    private static final class_2940<Boolean> DATA_IS_POWERED = class_2945.method_12791(BaseCreeper.class, (class_2941)class_2943.field_13323);
    private static final class_2940<Boolean> DATA_IS_IGNITED = class_2945.method_12791(BaseCreeper.class, (class_2941)class_2943.field_13323);
    private static final class_2940<Boolean> DATA_IS_ATTACKING = class_2945.method_12791(BaseCreeper.class, (class_2941)class_2943.field_13323);
    private static final class_2940<Boolean> DATA_IS_SHEARED = class_2945.method_12791(BaseCreeper.class, (class_2941)class_2943.field_13323);
    private int explosionRadius = 3;
    private int maxSwell = 30;
    private int swell;
    private int oldSwell;
    private int droppedSkulls;
    private final AnimationFactory factory = new AnimationFactory((IAnimatable)this);
    private final CreeperType type;

    public BaseCreeper(class_1299<? extends BaseCreeper> entityType, class_1937 level, CreeperType type) {
        super(entityType, level);
        this.type = type;
        if (!level.field_9236) {
            this.type.entities().forEach(e -> this.field_6185.method_6277(1, (class_1352)new class_1400((class_1308)this, e, true)));
        }
    }

    protected void method_5959() {
        this.field_6201.method_6277(1, (class_1352)new class_1347((class_1308)this));
        this.field_6201.method_6277(2, (class_1352)new CreeperSwellGoal(this));
        this.field_6201.method_6277(3, (class_1352)new CreeperAvoidEntitiesGoal(this, 6.0f, 1.0, 1.2));
        this.field_6201.method_6277(4, (class_1352)new CreeperMeleeAttackGoal(this, 1.0, false));
        this.field_6201.method_6277(5, (class_1352)new class_1394((class_1314)this, 0.8));
        this.field_6201.method_6277(6, (class_1352)new class_1361((class_1308)this, class_1657.class, 8.0f));
        this.field_6201.method_6277(6, (class_1352)new class_1376((class_1308)this));
        this.registerNearestAttackableTargetGoal();
        if (this.shouldRevenge()) {
            this.field_6185.method_6277(2, (class_1352)new class_1399((class_1314)this, new Class[0]));
        }
    }

    protected void registerNearestAttackableTargetGoal() {
        this.field_6185.method_6277(1, (class_1352)new class_1400((class_1308)this, class_1657.class, true));
    }

    protected boolean shouldRevenge() {
        return true;
    }

    protected void method_5693() {
        super.method_5693();
        this.field_6011.method_12784(DATA_IS_POWERED, (Object)false);
        this.field_6011.method_12784(DATA_SWELL_DIRECTION, (Object)-1);
        this.field_6011.method_12784(DATA_IS_IGNITED, (Object)false);
        this.field_6011.method_12784(DATA_IS_ATTACKING, (Object)false);
        this.field_6011.method_12784(DATA_IS_SHEARED, (Object)false);
    }

    public static class_5132.class_5133 createAttributes() {
        return class_1548.method_26908().method_26868(ModAttributes.REACH_DISTANCE, 0.0).method_26867(ModAttributes.SWIM_SPEED);
    }

    public void method_5652(@NotNull class_2487 compound) {
        super.method_5652(compound);
        if (((Boolean)this.field_6011.method_12789(DATA_IS_POWERED)).booleanValue()) {
            compound.method_10556("Powered", true);
        }
        compound.method_10575("Fuse", (short)this.maxSwell);
        compound.method_10567("ExplosionRadius", (byte)this.explosionRadius);
        if (((Boolean)this.field_6011.method_12789(DATA_IS_IGNITED)).booleanValue()) {
            compound.method_10556("ignited", true);
        }
        if (((Boolean)this.field_6011.method_12789(DATA_IS_SHEARED)).booleanValue()) {
            compound.method_10556("Sheared", true);
        }
    }

    public void method_5749(@NotNull class_2487 compound) {
        super.method_5749(compound);
        this.field_6011.method_12778(DATA_IS_POWERED, (Object)compound.method_10577("Powered"));
        if (compound.method_10573("Fuse", 99)) {
            this.maxSwell = compound.method_10568("Fuse");
        }
        if (compound.method_10573("ExplosionRadius", 99)) {
            this.explosionRadius = compound.method_10571("ExplosionRadius");
        }
        this.field_6011.method_12778(DATA_IS_IGNITED, (Object)compound.method_10577("ignited"));
        this.field_6011.method_12778(DATA_IS_SHEARED, (Object)compound.method_10577("Sheared"));
    }

    protected void method_6093() {
        this.method_18799(this.method_18798().method_1031(0.0, -0.04 * this.method_26825(ModAttributes.SWIM_SPEED), 0.0));
    }

    protected void method_6010(class_6862<class_3611> fluid) {
        this.method_18799(this.method_18798().method_1031(0.0, 0.04 * this.method_26825(ModAttributes.SWIM_SPEED), 0.0));
    }

    public void method_5724(float speed, class_243 movementInput) {
        class_3610 fluidState = this.field_6002.method_8316(this.method_24515());
        if (this.method_5799() && this.method_29920() && !this.method_26319(fluidState)) {
            super.method_5724(speed * (float)this.method_26825(ModAttributes.SWIM_SPEED), movementInput);
            return;
        }
        super.method_5724(speed, movementInput);
    }

    protected class_1269 method_5992(class_1657 player, class_1268 hand) {
        class_1799 itemStack = player.method_5998(hand);
        if (this.type.melee() == 0 && itemStack.method_31574(class_1802.field_8884)) {
            this.field_6002.method_8396(player, this.method_24515(), class_3417.field_15145, this.method_5634(), 1.0f, this.field_5974.nextFloat() * 0.4f + 0.8f);
            if (!this.field_6002.field_9236) {
                this.field_6011.method_12778(DATA_IS_IGNITED, (Object)true);
                itemStack.method_7956(1, (class_1309)player, p -> p.method_20236(hand));
            }
            return class_1269.method_29236((boolean)this.field_6002.field_9236);
        }
        if (this.type.shearable() && !this.isSheared() && itemStack.method_31574(class_1802.field_8868)) {
            this.field_6002.method_8396(player, this.method_24515(), class_3417.field_22273, this.method_5634(), 1.0f, this.field_5974.nextFloat() * 0.4f + 0.8f);
            if (!this.field_6002.field_9236) {
                this.field_6011.method_12778(DATA_IS_SHEARED, (Object)true);
                itemStack.method_7956(1, (class_1309)player, p -> p.method_20236(hand));
                this.method_5699(new class_1799((class_1935)ModItems.TINY_CACTUS), 1.7f);
            }
            return class_1269.method_29236((boolean)this.field_6002.field_9236);
        }
        return super.method_5992(player, hand);
    }

    public boolean isSheared() {
        return (Boolean)this.field_6011.method_12789(DATA_IS_SHEARED);
    }

    public void method_5773() {
        if (this.method_5805()) {
            if (this.getSwellDirection() > 0 && this.swell == 0) {
                this.method_5783(class_3417.field_15057, 1.0f, 0.5f);
                this.method_32876(class_5712.field_28727);
            }
            this.updateSwell(Math.max(this.swell + this.getSwellDirection(), 0));
            if (this.swell >= this.maxSwell) {
                this.updateSwell(this.maxSwell);
                this.explode();
            }
        }
        super.method_5773();
    }

    public void explode() {
        if (!this.field_6002.method_8608()) {
            class_1927.class_4179 destructionType = this.field_6002.method_8450().method_8355(class_1928.field_19388) ? class_1927.class_4179.field_18687 : class_1927.class_4179.field_18685;
            this.field_6272 = true;
            class_1927 explosion = this.field_6002.method_8437((class_1297)this, this.method_23317(), this.method_23318(), this.method_23321(), (float)this.explosionRadius * (this.isPowered() ? 2.0f : 1.0f), destructionType);
            this.method_31472();
            if (!this.type.inflictingPotions().isEmpty()) {
                explosion.method_8351().keySet().forEach(player -> {
                    List<class_1293> inflictingPotions = this.type.inflictingPotions().stream().map(class_1293::new).toList();
                    inflictingPotions.forEach(arg_0 -> ((class_1657)player).method_6092(arg_0));
                });
            }
            if (this.type.dirtReplacement() != null) {
                class_2248 replacement = this.type.dirtReplacement().get();
                explosion.method_8346().stream().map(class_2338::method_10074).filter(pos -> {
                    class_2680 state = this.field_6002.method_8320(pos);
                    return (state.method_27852(class_2246.field_10219) || state.method_27852(class_2246.field_10566)) && this.field_5974.nextInt(3) == 0;
                }).forEach(pos -> this.field_6002.method_8652(pos, replacement.method_9564(), 3));
            }
            List<class_1293> collection = this.method_6026().stream().map(class_1293::new).toList();
            this.summonCloudWithEffects(collection);
            this.summonCloudWithEffects(this.getCreeperType().potionsWhenDead().stream().map(class_1293::new).toList());
        }
    }

    private void summonCloudWithEffects(Collection<class_1293> effects) {
        if (!effects.isEmpty()) {
            class_1295 cloud = new class_1295(this.field_6002, this.method_23317(), this.method_23318(), this.method_23321());
            cloud.method_5603(2.5f);
            cloud.method_5609(-0.5f);
            cloud.method_5595(10);
            cloud.method_5604(cloud.method_5605() / 2);
            cloud.method_5609(cloud.method_5599() / (float)cloud.method_5605());
            effects.forEach(arg_0 -> ((class_1295)cloud).method_5610(arg_0));
            this.field_6002.method_8649((class_1297)cloud);
        }
    }

    public void method_5800(class_3218 world, class_1538 lightning) {
        super.method_5800(world, lightning);
        this.field_6011.method_12778(DATA_IS_POWERED, (Object)true);
    }

    public double method_26825(class_1320 attribute) {
        double val = super.method_26825(attribute);
        return attribute.equals(class_5134.field_23721) && this.isPowered() ? val * 10.0 : val;
    }

    public boolean method_6121(class_1297 target) {
        return this.type.melee() == 0 || super.method_6121(target);
    }

    public CreeperType getCreeperType() {
        return this.type;
    }

    public float method_6029() {
        if (!this.isPowered()) {
            return super.method_6029();
        }
        return super.method_6029() * 1.5f;
    }

    public boolean isAfraidOf(class_1297 entity) {
        return this.type.entitiesAfraidOf().contains(entity.method_5864());
    }

    public void setAttack(boolean attack) {
        this.field_6011.method_12778(DATA_IS_ATTACKING, (Object)attack);
    }

    public boolean method_6872() {
        return (Boolean)this.field_6011.method_12789(DATA_IS_POWERED);
    }

    public boolean isPowered() {
        return (Boolean)this.field_6011.method_12789(DATA_IS_POWERED);
    }

    public boolean activated() {
        return (Boolean)this.field_6011.method_12789(DATA_IS_IGNITED);
    }

    public int getSwellDirection() {
        return (Integer)this.field_6011.method_12789(DATA_SWELL_DIRECTION);
    }

    public void changeSwellDirection(int direction) {
        this.field_6011.method_12778(DATA_SWELL_DIRECTION, (Object)direction);
    }

    public void updateSwell(int amount) {
        this.oldSwell = this.swell;
        this.swell = amount;
    }

    public float getSwelling(float partialTicks) {
        return class_3532.method_16439((float)partialTicks, (float)this.oldSwell, (float)this.swell) / (float)(this.maxSwell - 2);
    }

    public boolean canSwell() {
        return this.type.melee() == 0;
    }

    public boolean canDropMobsSkull() {
        return this.isPowered() && this.droppedSkulls < 1;
    }

    public void increaseDroppedSkulls() {
        ++this.droppedSkulls;
    }

    private <E extends IAnimatable> PlayState idle(AnimationEvent<E> event) {
        event.getController().setAnimation(new AnimationBuilder().addAnimation("animation.creeper.idle", Boolean.valueOf(true)));
        return PlayState.CONTINUE;
    }

    private <E extends IAnimatable> PlayState action(AnimationEvent<E> event) {
        Animation animation = event.getController().getCurrentAnimation();
        if (((Boolean)this.field_6011.method_12789(DATA_IS_ATTACKING)).booleanValue()) {
            event.getController().setAnimation(new AnimationBuilder().addAnimation("animation.creeper.attack", Boolean.valueOf(false)));
            return PlayState.CONTINUE;
        }
        if (animation != null && animation.animationName.equals("animation.creeper.attack") && event.getController().getAnimationState().equals((Object)AnimationState.Running)) {
            return PlayState.CONTINUE;
        }
        if (event.isMoving()) {
            event.getController().setAnimation(new AnimationBuilder().addAnimation("animation.creeper.walk", Boolean.valueOf(true)));
            return PlayState.CONTINUE;
        }
        event.getController().markNeedsReload();
        return PlayState.STOP;
    }

    public void registerControllers(AnimationData data) {
        data.addAnimationController(new AnimationController((IAnimatable)this, "action_controller", 3.0f, this::action));
        data.addAnimationController(new AnimationController((IAnimatable)this, "idle_controller", 0.0f, this::idle));
    }

    public AnimationFactory getFactory() {
        return this.factory;
    }
}

